/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.entity.mixin.common;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.github.fabricators_of_create.porting_lib.core.event.BaseEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingAttackEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingDeathEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityUseItemEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.ShieldBlockEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingDamageEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingHurtEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.living.MobEffectEvent;
import io.github.fabricators_of_create.porting_lib.entity.extensions.EntityExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements EntityExtensions {
    @Shadow
    protected int field_6238;
    @Shadow
    @Nullable
    protected class_1657 field_6258;
    private int port_lib$lootingLevel;
    @Unique
    private LivingEntityEvents.Fall.FallEvent port_lib$currentFallEvent = null;

    @Shadow
    public abstract class_1799 method_6030();

    @Shadow
    public abstract int method_6014();

    public LivingEntityMixin(class_1299<?> variant, class_1937 world) {
        super(variant, world);
    }

    @ModifyVariable(method={"dropAllDeathLoot"}, at=@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;lastHurtByPlayerTime:I"))
    private int port_lib$grabLootingLevel(int lootingLevel) {
        this.port_lib$lootingLevel = lootingLevel;
        return lootingLevel;
    }

    @ModifyArgs(method={"dropAllDeathLoot"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;dropCustomDeathLoot(Lnet/minecraft/world/damagesource/DamageSource;IZ)V"))
    private void port_lib$modifyLootingLevel(Args args) {
        class_1282 source = (class_1282)args.get(0);
        int originalLevel = (Integer)args.get(1);
        boolean recentlyHit = (Boolean)args.get(2);
        int modifiedLevel = ((LivingEntityEvents.LootingLevel)LivingEntityEvents.LOOTING_LEVEL.invoker()).modifyLootingLevel(source, (class_1309)this, originalLevel, recentlyHit);
        args.set(1, (Object)modifiedLevel);
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="HEAD")})
    private void port_lib$startCapturingDrops(class_1282 damageSource, CallbackInfo ci) {
        this.captureDrops(new ArrayList());
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="RETURN")})
    private void port_lib$dropCapturedDrops(class_1282 source, CallbackInfo ci) {
        Collection drops = this.captureDrops(null);
        boolean cancelled = ((LivingEntityEvents.Drops)LivingEntityEvents.DROPS.invoker()).onLivingEntityDrops((class_1309)this, source, drops, this.port_lib$lootingLevel, this.field_6238 > 0);
        if (!cancelled) {
            drops.forEach(e -> this.method_37908().method_8649((class_1297)e));
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void port_lib$cancelFall(float fallDistance, float multiplier, class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        this.port_lib$currentFallEvent = new LivingEntityEvents.Fall.FallEvent((class_1309)this, source, fallDistance, multiplier);
        this.port_lib$currentFallEvent.sendEvent();
        if (this.port_lib$currentFallEvent.isCanceled()) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"causeFallDamage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    public float port_lib$modifyDistance(float fallDistance) {
        if (this.port_lib$currentFallEvent != null) {
            return this.port_lib$currentFallEvent.getDistance();
        }
        return fallDistance;
    }

    @ModifyVariable(method={"causeFallDamage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=1)
    public float port_lib$modifyMultiplier(float multiplier) {
        if (this.port_lib$currentFallEvent != null) {
            return this.port_lib$currentFallEvent.getDamageMultiplier();
        }
        return multiplier;
    }

    @ModifyArgs(method={"dropExperience"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V"))
    private void create$dropExperience(Args args) {
        int newAmount;
        int amount = (Integer)args.get(2);
        if (amount != (newAmount = ((LivingEntityEvents.ExperienceDrop)LivingEntityEvents.EXPERIENCE_DROP.invoker()).onLivingEntityExperienceDrop(amount, this.field_6258, (class_1309)this))) {
            args.set(2, (Object)newAmount);
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V")}, cancellable=true)
    private void tick(CallbackInfo ci) {
        LivingEntityEvents.LivingTickEvent event = new LivingEntityEvents.LivingTickEvent((class_1309)this);
        event.sendEvent();
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @ModifyVariable(method={"knockback"}, at=@At(value="STORE"), ordinal=0, argsOnly=true)
    private double port_lib$takeKnockback(double f) {
        if (this.field_6258 != null) {
            return ((LivingEntityEvents.KnockBackStrength)LivingEntityEvents.KNOCKBACK_STRENGTH.invoker()).onLivingEntityTakeKnockback(f, this.field_6258);
        }
        return f;
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), argsOnly=true)
    private float port_lib$onHurt(float amount, class_1282 source, float amount2) {
        return ((LivingEntityEvents.ActuallyHurt)LivingEntityEvents.HURT.invoker()).onHurt(source, (class_1309)this, amount);
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="TAIL")})
    public void onJump(CallbackInfo ci) {
        new LivingEntityEvents.LivingJumpEvent((class_1309)this).sendEvent();
    }

    @Inject(method={"completeUsingItem"}, at={@At(value="INVOKE", shift=At.Shift.BY, by=2, target="Lnet/minecraft/world/item/ItemStack;finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void port_lib$onFinishUsing(CallbackInfo ci, class_1268 hand, class_1799 result) {
        ((LivingEntityUseItemEvents.LivingUseItemFinish)LivingEntityUseItemEvents.LIVING_USE_ITEM_FINISH.invoker()).onUseItem((class_1309)this, this.method_6030().method_7972(), this.method_6014(), result);
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void port_lib$attackEvent(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!(this instanceof class_1657)) {
            LivingAttackEvent event = new LivingAttackEvent((class_1309)this, source, amount);
            event.sendEvent();
            if (event.isCanceled()) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @ModifyReturnValue(method={"getVisibilityPercent"}, at={@At(value="RETURN")})
    private double modifyVisibility(double original, @javax.annotation.Nullable class_1297 pLookingEntity) {
        LivingEntityEvents.LivingVisibilityEvent event = new LivingEntityEvents.LivingVisibilityEvent((class_1309)this, pLookingEntity, original);
        event.sendEvent();
        return Math.max(0.0, event.getVisibilityModifier());
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    private void onLivingDeath(class_1282 cause, CallbackInfo ci) {
        LivingDeathEvent event = new LivingDeathEvent((class_1309)this, cause);
        event.sendEvent();
        if (event.isCanceled()) {
            ci.cancel();
        }
    }

    @ModifyExpressionValue(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z")})
    private boolean shieldBlockEvent(boolean original, class_1282 pSource, float pAmount, @Share(value="shield_block") LocalRef<ShieldBlockEvent> eventRef) {
        if (original) {
            ShieldBlockEvent event = new ShieldBlockEvent((class_1309)this, pSource, pAmount);
            event.sendEvent();
            eventRef.set((Object)event);
            return !event.isCanceled();
        }
        return original;
    }

    @WrapWithCondition(method={"hurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hurtCurrentlyUsedShield(F)V")})
    private boolean shieldTakesDamage(class_1309 entity, float damage, @Share(value="shield_block") LocalRef<ShieldBlockEvent> eventRef) {
        return ((ShieldBlockEvent)((Object)eventRef.get())).shieldTakesDamage();
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="STORE", ordinal=1), index=5)
    private float modifyBlockedDamage(float value, @Share(value="shield_block") LocalRef<ShieldBlockEvent> eventRef) {
        return ((ShieldBlockEvent)((Object)eventRef.get())).getBlockedDamage();
    }

    @ModifyExpressionValue(method={"hurt"}, at={@At(value="CONSTANT", args={"floatValue=0"}, ordinal=2)})
    private float modifyActualDamage(float value, class_1282 pSource, float pAmount, @Share(value="shield_block") LocalRef<ShieldBlockEvent> eventRef) {
        return pAmount - ((ShieldBlockEvent)((Object)eventRef.get())).getBlockedDamage();
    }

    @ModifyVariable(method={"actuallyHurt"}, at=@At(value="LOAD", ordinal=0), index=2)
    private float livingHurtEvent(float value, class_1282 pDamageSource, @Share(value="hurt") LocalRef<LivingHurtEvent> eventRef) {
        LivingHurtEvent event = new LivingHurtEvent((class_1309)this, pDamageSource, value);
        eventRef.set((Object)event);
        event.sendEvent();
        if (event.isCanceled()) {
            return 0.0f;
        }
        return event.getAmount();
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F")}, cancellable=true)
    private void shouldCancelHurt(class_1282 damageSource, float f, CallbackInfo ci, @Share(value="hurt") LocalRef<LivingHurtEvent> eventRef) {
        if (((LivingHurtEvent)((Object)eventRef.get())).getAmount() <= 0.0f) {
            ci.cancel();
        }
    }

    @ModifyVariable(method={"actuallyHurt"}, at=@At(value="LOAD", ordinal=6), index=2)
    private float livingDamageEvent(float value, class_1282 pDamageSource) {
        LivingDamageEvent event = new LivingDamageEvent((class_1309)this, pDamageSource, value);
        event.sendEvent();
        if (event.isCanceled()) {
            return 0.0f;
        }
        return event.getAmount();
    }

    @Inject(method={"removeEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRemoveEffect(class_1291 effect, CallbackInfoReturnable<Boolean> cir) {
        MobEffectEvent.Remove event = new MobEffectEvent.Remove((class_1309)this, effect);
        event.sendEvent();
        if (event.isCanceled()) {
            cir.setReturnValue((Object)false);
        }
    }

    @WrapWithCondition(method={"removeAllEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;onEffectRemoved(Lnet/minecraft/world/effect/MobEffectInstance;)V")})
    private boolean onRemoveAllEffectEvent(class_1309 instance, class_1293 effect, @Share(value="event") LocalRef<MobEffectEvent.Remove> eventRef) {
        MobEffectEvent.Remove event = new MobEffectEvent.Remove(instance, effect);
        eventRef.set((Object)event);
        event.sendEvent();
        return !event.isCanceled();
    }

    @WrapWithCondition(method={"removeAllEffects"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;remove()V")})
    private boolean skipRemove(Iterator<class_1293> iterator, @Share(value="event") LocalRef<MobEffectEvent.Remove> eventRef) {
        return !((MobEffectEvent.Remove)((Object)eventRef.get())).isCanceled();
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    private void isEffectApplicable(class_1293 effectInstance, CallbackInfoReturnable<Boolean> cir) {
        MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((class_1309)this, effectInstance);
        event.sendEvent();
        if (event.getResult() != BaseEvent.Result.DEFAULT) {
            cir.setReturnValue((Object)(event.getResult() == BaseEvent.Result.ALLOW ? 1 : 0));
        }
    }

    @Inject(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="JUMP", opcode=199)})
    private void onEffectAdded(class_1293 newEffect, class_1297 entity, CallbackInfoReturnable<Boolean> cir, @Local(index=3) class_1293 oldEffect) {
        new MobEffectEvent.Added((class_1309)this, oldEffect, newEffect, entity).sendEvent();
    }

    @ModifyExpressionValue(method={"tickEffects"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/Level;isClientSide:Z", ordinal=0)})
    private boolean onEffectExpired(boolean original, @Local(index=3) class_1293 effect) {
        return original || new MobEffectEvent.Expired((class_1309)this, effect).post();
    }
}

